//------------------------------------------------------------
// VelociBus_4X4BP Button Illumination Effects Example
//   Top two rows of buttons select effect
//   Bottom right 2 buttons are brightness down/up
//   All other buttons blank the display
//------------------------------------------------------------

#include "VelociBus_4X4BP.h"
VelociBus_4X4BP vbus; // create VelociBus interface, one required for each serial port used
#define VBUS_SERIAL Serial2

void setup() 
{
  Serial.begin(115200); // Serial monitor
  // button module on VeliciBus
  VBUS_SERIAL.begin(38400);    // VelociBus is always 38400
  // establish communication
  for (;;)
  { Serial.println("PROBING VelociBus...");
    if (vbus.begin( &VBUS_SERIAL )) break; // performs loopback diagnostic, tries 3 times, sets board_count
    delay(1000);
  }
  Serial.print("Found "); Serial.print(vbus.board_count); Serial.println(" Button Pad Modules");
  // establish button handler
  vbus.setHandler( myButtonHandler ); // establish button handler callback
  // all we want is press & release events
  vbus.setButtonHoldEnable( false );    // don't report long press events
  vbus.setButtonReleaseEnable( false ); // don't report button release events
}

void loop() 
{
  vbus.loop(); // required, triggers button events
}

// button event callback
void myButtonHandler( [[maybe_unused]]uint8_t board_address, uint8_t button_index, [[maybe_unused]]VelociBus_4X4BP::button_event_code event )
{
Serial.println("CALLBACK");  
//  if (event == VelociBus_4X4BP::BTN_PRESS)

  switch (button_index)
  {
    default: // all off
      vbus.setLEDall( VelociBus_4X4BP::BOARD_BROADCAST_ADDR, VelociBus_4X4BP::FCN_COLOR, VelociBus_4X4BP::black );
      break;
      
    case 0: // solid colorset
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_COLOR, (VelociBus_4X4BP::color_code)i );
      break;
        
    case 1: // slow breathe
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_BREATHE_S, (VelociBus_4X4BP::color_code)i );
      break;

    case 2: // fast breathe
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_BREATHE_F, (VelociBus_4X4BP::color_code)i );
      break;

    case 3: // slow blink
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_BLINK_S, (VelociBus_4X4BP::color_code)i );
      break;
      
    case 4: // fast blink
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_BLINK_F, (VelociBus_4X4BP::color_code)i );
      break;

    case 5: // color wheel
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_WHEEL, (VelociBus_4X4BP::color_code)i );
      break;
      
    case 6: // fade out
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_FADEOUT, (VelociBus_4X4BP::color_code)i );
      break;
    
    case 7: // flash in
      for (uint i=0; i < 16; i++)
        vbus.setLED( board_address, i, VelociBus_4X4BP::FCN_FLASHIN, (VelociBus_4X4BP::color_code)i );
      break;

    case 14: // brightness down
        vbus.bumpBrightness( -1 );
        break;
    
    case 15: // brightness up
        vbus.bumpBrightness( 1 );
  }    
}
